assert(load(assert(builder:open_text("setup_utility.lua"))))()
builder:set_default_size(30, 30)
standard_setup({
  main = {"advanced_level_utility.lua", "level_logic.lua"},
  blocks = {"Red.png", "Blue.png", "Green.png"},
  info_panel = {
    {tab = "Goal", contents = {
      info_title("Specification"),
      info_desc("A binary number is a string of 0's and 1's (called bits). These are encoded by the height of the columns of the inputs:"),
      low_level_figure({
        {object = "binary_example", width = 0.8, position = Vectord.new(0, 0)},
        {text = "0", height = 0.06, position = Vectord.new(-0.35, -0.15)},
        {text = "0", height = 0.06, position = Vectord.new(-0.25, -0.15)},
        {text = "0", height = 0.06, position = Vectord.new(-0.15, -0.15)},
        {text = "1", height = 0.06, position = Vectord.new(-0.05, -0.15)},
        {text = "0", height = 0.06, position = Vectord.new(0.05, -0.15)},
        {text = "1", height = 0.06, position = Vectord.new(0.15, -0.15)},
        {text = "1", height = 0.06, position = Vectord.new(0.25, -0.15)},
        {text = "0", height = 0.06, position = Vectord.new(0.35, -0.15)}
      }),
      info_desc("This figure represents the binary number 00010110. "),
      low_level_figure({
        {object = "binary_example", width = 0.8, position = Vectord.new(0, 0)},
        {text = "128", height = 0.06, position = Vectord.new(-0.35, -0.15)},
        {text = "64", height = 0.06, position = Vectord.new(-0.25, -0.15)},
        {text = "32", height = 0.06, position = Vectord.new(-0.15, -0.15)},
        {text = "16", height = 0.06, position = Vectord.new(-0.05, -0.15)},
        {text = "8", height = 0.06, position = Vectord.new(0.05, -0.15)},
        {text = "4", height = 0.06, position = Vectord.new(0.15, -0.15)},
        {text = "2", height = 0.06, position = Vectord.new(0.25, -0.15)},
        {text = "1", height = 0.06, position = Vectord.new(0.35, -0.15)},

        {text = "16", height = 0.06, position = Vectord.new(-0.05, -0.25)},
        {text = "+", height = 0.06, position = Vectord.new(0.05, -0.25)},
        {text = "4", height = 0.06, position = Vectord.new(0.15, -0.25)},
        {text = "+", height = 0.06, position = Vectord.new(0.2, -0.25)},
        {text = "2", height = 0.06, position = Vectord.new(0.25, -0.25)},
        {text = "= 22", height = 0.06, position = Vectord.new(0.4, -0.25), align_horizontal = ALIGN_LOWER},
      }),
      info_desc("Each bit has a place value of some power of two; the rightmost place is the 1's place, the next the 2's and so on. The represented number is the sum of all the place values with a '1' bit - so here the occupied place values are 16, 4, and 2, giving a sum of 22.\nPairs of such encoded numbers will be input. Sum them and output the rightmost 8 bits of the encoded result.\nSee Add and Example for more details.")
    }},
    {tab = "Add 1", contents = {
      info_title("How to Add (Page 1)"),
      low_level_figure({
        {text = "0", height = 0.06, position = Vectord.new(-0.2, 0), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.2, 0), align_vertical = ALIGN_LOWER},

        {text = "+", height = 0.06, position = Vectord.new(-0.3, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.2, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.2, -0.1), align_vertical = ALIGN_LOWER},
        {rect = Rectangled.new(-0.33, -0.12, 0.23, -0.11)},

        {text = "1", height = 0.06, position = Vectord.new(0.2, -0.2), align_vertical = ALIGN_LOWER, color = {1, 1, 0.2, 1}},
        {box = Rectangled.new(0.15, 0.08, 0.25, -0.25), thickness = 0.005, color = {0.7, 0.7, 0.7, 1}}
      }),
      info_desc("We start at the right; here, the rightmost bits are 0 and 1, and 0 + 1 = 1, so we write a 1 as the answer."),
      low_level_figure({
        {text = "0", height = 0.06, position = Vectord.new(-0.2, 0), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.2, 0), align_vertical = ALIGN_LOWER},

        {text = "+", height = 0.06, position = Vectord.new(-0.3, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.2, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.2, -0.1), align_vertical = ALIGN_LOWER},
        {rect = Rectangled.new(-0.33, -0.12, 0.23, -0.11)},

        {text = "1", height = 0.06, position = Vectord.new(0.2, -0.2), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.1, -0.2), align_vertical = ALIGN_LOWER, color = {1, 1, 0.2, 1}},
        {text = "1", height = 0.06, position = Vectord.new(0, 0.1), align_vertical = ALIGN_LOWER, color = {1, 1, 0.2, 1}},
        {box = Rectangled.new(0.05, 0.08, 0.15, -0.25), thickness = 0.005, color = {0.7, 0.7, 0.7, 1}}
      }),
      info_desc("We then proceed to the next column. Here, the bits are 1 and 1. In binary, 1 + 1 = 10, so we need to carry a 1 to the next column and write 0 in the output."),
      low_level_figure({
        {text = "0", height = 0.06, position = Vectord.new(-0.2, 0), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.2, 0), align_vertical = ALIGN_LOWER},

        {text = "+", height = 0.06, position = Vectord.new(-0.3, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.2, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.2, -0.1), align_vertical = ALIGN_LOWER},
        {rect = Rectangled.new(-0.33, -0.12, 0.23, -0.11)},

        {text = "1", height = 0.06, position = Vectord.new(0.2, -0.2), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.1, -0.2), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, 0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, -0.2), align_vertical = ALIGN_LOWER, color = {1, 1, 0.2, 1}},
        {text = "1", height = 0.06, position = Vectord.new(-0.1, 0.1), align_vertical = ALIGN_LOWER, color = {1, 1, 0.2, 1}},

        {box = Rectangled.new(-0.05, 0.18, 0.05, -0.25), thickness = 0.005, color = {0.7, 0.7, 0.7, 1}}
      }),
      info_desc("Due to the carry, the next column is 1 + 1 + 1 = 11, so we write a 1 and carry a 1.")
    }},
    {tab = "Add 2", contents = {
      info_title("How to Add (Page 2)"),
      low_level_figure({
        {text = "0", height = 0.06, position = Vectord.new(-0.2, 0), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.2, 0), align_vertical = ALIGN_LOWER},

        {text = "+", height = 0.06, position = Vectord.new(-0.3, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.2, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.2, -0.1), align_vertical = ALIGN_LOWER},
        {rect = Rectangled.new(-0.33, -0.12, 0.23, -0.11)},

        {text = "1", height = 0.06, position = Vectord.new(0.2, -0.2), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.1, -0.2), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, 0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, -0.2), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.1, 0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.1, -0.2), align_vertical = ALIGN_LOWER, color = {1, 1, 0.2, 1}},
        {text = "1", height = 0.06, position = Vectord.new(-0.2, 0.1), align_vertical = ALIGN_LOWER, color = {1, 1, 0.2, 1}},

        {box = Rectangled.new(-0.15, 0.18, -0.05, -0.25), thickness = 0.005, color = {0.7, 0.7, 0.7, 1}}
      }),
      info_desc("We continue analogously to the next column, writing 0 and carrying 1."),
      low_level_figure({
        {text = "0", height = 0.06, position = Vectord.new(-0.2, 0), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, 0), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.2, 0), align_vertical = ALIGN_LOWER},

        {text = "+", height = 0.06, position = Vectord.new(-0.3, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.2, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, -0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0.1, -0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.2, -0.1), align_vertical = ALIGN_LOWER},
        {rect = Rectangled.new(-0.33, -0.12, 0.23, -0.11)},

        {text = "1", height = 0.06, position = Vectord.new(0.2, -0.2), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(0.1, -0.2), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, 0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(0, -0.2), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.1, 0.1), align_vertical = ALIGN_LOWER},
        {text = "0", height = 0.06, position = Vectord.new(-0.1, -0.2), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.2, 0.1), align_vertical = ALIGN_LOWER},
        {text = "1", height = 0.06, position = Vectord.new(-0.2, -0.2), align_vertical = ALIGN_LOWER, color = {1, 1, 0.2, 1}},

        {box = Rectangled.new(-0.25, 0.18, -0.15, -0.25), thickness = 0.005, color = {0.7, 0.7, 0.7, 1}}
      }),
      info_desc("Finally, we compute the final row of the computation, seeing 00111 + 01110 = 10101.\nNote that, in the event that the final column leads to a carry, this carry should be ignored - for this challenge, on the last eight bits of the addition are desired.")
    }},
    {tab = "Example 1", contents = {
      info_title("Examples (Page 1)"),
      low_level_figure({
        {object = "red1", height = 0.2, position = Vectord.new(0, 0)},
        {object = "blue1", height = 0.2, position = Vectord.new(0, -0.25)},
        {text = "Input 0:", height = 0.06, position = Vectord.new(-0.55, 0), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {text = "Input 1:", height = 0.06, position = Vectord.new(-0.55, -0.25), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0, -0.425)},
        {object = "out1", height = 0.2, position = Vectord.new(0, -0.6)},
        {text = "Output:", height = 0.06, position = Vectord.new(-0.55, -0.6), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}}
      }),
      info_vspace(0.05),
      low_level_figure({
        {object = "red2", height = 0.2, position = Vectord.new(0, 0)},
        {object = "blue2", height = 0.2, position = Vectord.new(0, -0.25)},
        {text = "Input 0:", height = 0.06, position = Vectord.new(-0.55, 0), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {text = "Input 1:", height = 0.06, position = Vectord.new(-0.55, -0.25), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0, -0.425)},
        {object = "out2", height = 0.2, position = Vectord.new(0, -0.6)},
        {text = "Output:", height = 0.06, position = Vectord.new(-0.55, -0.6), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}}
      })
    }},
    {tab = "Example 2", contents = {
      info_title("Examples (Page 2)"),
      low_level_figure({
        {object = "red3", height = 0.2, position = Vectord.new(0, 0)},
        {object = "blue3", height = 0.2, position = Vectord.new(0, -0.25)},
        {text = "Input 0:", height = 0.06, position = Vectord.new(-0.55, 0), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {text = "Input 1:", height = 0.06, position = Vectord.new(-0.55, -0.25), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0, -0.425)},
        {object = "out3", height = 0.2, position = Vectord.new(0, -0.6)},
        {text = "Output:", height = 0.06, position = Vectord.new(-0.55, -0.6), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {text = "(Ignore carries past 8th bit)", height = 0.04, position = Vectord.new(0, -0.73), color = {1, 1, 1, 0.75}}
      }),
      info_vspace(0),
      low_level_figure({
        {object = "red4", height = 0.2, position = Vectord.new(0, 0)},
        {object = "blue4", height = 0.2, position = Vectord.new(0, -0.25)},
        {text = "Input 0:", height = 0.06, position = Vectord.new(-0.55, 0), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {text = "Input 1:", height = 0.06, position = Vectord.new(-0.55, -0.25), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}},
        {image = "ArrowDown.png", height = 0.1, position = Vectord.new(0, -0.425)},
        {object = "out4", height = 0.2, position = Vectord.new(0, -0.6)},
        {text = "Output:", height = 0.06, position = Vectord.new(-0.55, -0.6), align_horizontal = ALIGN_UPPER, color = {1, 1, 1, 0.5}}
      })
    }}
  },
  standard_resize = true
})
